ALTER TABLE PPSNEPL.EPL_CLASS_TYPES
 DROP PRIMARY KEY CASCADE;

DROP TABLE PPSNEPL.EPL_CLASS_TYPES CASCADE CONSTRAINTS;

CREATE TABLE PPSNEPL.EPL_CLASS_TYPES
(
  ID                 NUMBER(30)                 NOT NULL,
  CLASS_TYPE_CODE    VARCHAR2(1)                NOT NULL,
  CLASS_TYPE_DESC    VARCHAR2(50 BYTE)          NOT NULL,
  CREATED_BY         VARCHAR2(50 BYTE)          NOT NULL,
  CREATED_DTM        TIMESTAMP(6)               NOT NULL,
  LAST_MODIFIED_BY   VARCHAR2(50 BYTE),
  LAST_MODIFIED_DTM  TIMESTAMP(6)
)
TABLESPACE PPSNEPL_DATA
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
RESULT_CACHE (MODE DEFAULT)
NOPARALLEL
MONITORING;

CREATE OR REPLACE PUBLIC SYNONYM EPL_CLASS_TYPES FOR PPSNEPL.EPL_CLASS_TYPES;

ALTER TABLE PPSNEPL.EPL_CLASS_TYPES ADD (
  CONSTRAINT EPL_CLASS_TYPES_PK
  PRIMARY KEY
  (ID)
  USING INDEX
    TABLESPACE PPSNEPL_INDEX
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                NEXT             1M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
  ENABLE VALIDATE);
 
 
GRANT SELECT ON PPSNEPL.EPL_CLASS_TYPES TO PPSNEPL_READ_ONLY_ROLE;

GRANT DELETE, INSERT, UPDATE ON PPSNEPL.EPL_CLASS_TYPES TO PPSNEPL_UPDATE_ROLE;
